/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.tileentity;

import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModBlockEntityTypes;
import com.tiviacz.travelersbackpack.init.ModBlocks;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import com.tiviacz.travelersbackpack.inventory.InventoryActions;
import com.tiviacz.travelersbackpack.inventory.InventoryImproved;
import com.tiviacz.travelersbackpack.inventory.screen.TravelersBackpackBlockEntityScreenHandler;
import com.tiviacz.travelersbackpack.util.InventoryUtils;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.impl.transfer.fluid.FluidVariantImpl;
import net.minecraft.class_1262;
import net.minecraft.class_1275;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_5431;
import org.jetbrains.annotations.Nullable;

public class TravelersBackpackBlockEntity
extends class_2586
implements ITravelersBackpackInventory,
class_1275 {
    public InventoryImproved inventory = this.createInventory(45);
    public InventoryImproved craftingInventory = this.createInventory(9);
    public SingleVariantStorage<FluidVariant> leftTank = this.createFluidTank(TravelersBackpackConfig.tanksCapacity);
    public SingleVariantStorage<FluidVariant> rightTank = this.createFluidTank(TravelersBackpackConfig.tanksCapacity);
    private boolean isSleepingBagDeployed = false;
    private int color = 0;
    private int lastTime = 0;
    private class_2561 customName = null;
    private final String LEFT_TANK = "LeftTank";
    private final String LEFT_TANK_AMOUNT = "LeftTankAmount";
    private final String RIGHT_TANK = "RightTank";
    private final String RIGHT_TANK_AMOUNT = "RightTankAmount";
    private final String SLEEPING_BAG = "SleepingBag";
    private final String COLOR = "Color";
    private final String LAST_TIME = "LastTime";
    private final String CUSTOM_NAME = "CustomName";

    public TravelersBackpackBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntityTypes.TRAVELERS_BACKPACK_BLOCK_ENTITY_TYPE, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.readAllData(nbt);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.writeAllData(tag);
    }

    @Override
    public void writeItems(class_2487 compound) {
        InventoryUtils.writeNbt(compound, this.inventory.getStacks(), true, false);
        InventoryUtils.writeNbt(compound, this.craftingInventory.getStacks(), true, true);
    }

    @Override
    public void readItems(class_2487 compound) {
        this.inventory = this.createInventory(45);
        this.craftingInventory = this.createInventory(9);
        InventoryUtils.readNbt(compound, this.inventory.getStacks(), false);
        InventoryUtils.readNbt(compound, this.craftingInventory.getStacks(), true);
    }

    @Override
    public void writeTanks(class_2487 compound) {
        compound.method_10566("LeftTank", (class_2520)((FluidVariant)this.getLeftTank().variant).toNbt());
        compound.method_10566("RightTank", (class_2520)((FluidVariant)this.getRightTank().variant).toNbt());
        compound.method_10544("LeftTankAmount", this.getLeftTank().amount);
        compound.method_10544("RightTankAmount", this.getRightTank().amount);
    }

    @Override
    public void readTanks(class_2487 compound) {
        this.leftTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("LeftTank"));
        this.rightTank.variant = FluidVariantImpl.fromNbt((class_2487)compound.method_10562("RightTank"));
        this.leftTank.amount = compound.method_10537("LeftTankAmount");
        this.rightTank.amount = compound.method_10537("RightTankAmount");
    }

    @Override
    public void writeColor(class_2487 compound) {
        compound.method_10569("Color", this.color);
    }

    @Override
    public void readColor(class_2487 compound) {
        this.color = compound.method_10550("Color");
    }

    public void writeSleepingBag(class_2487 compound) {
        compound.method_10556("SleepingBag", this.isSleepingBagDeployed);
    }

    public void readSleepingBag(class_2487 compound) {
        this.isSleepingBagDeployed = compound.method_10577("SleepingBag");
    }

    public void writeName(class_2487 compound) {
        if (this.customName != null) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
    }

    public void readName(class_2487 compound) {
        if (compound.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)compound.method_10558("CustomName"));
        }
    }

    @Override
    public void writeTime(class_2487 compound) {
    }

    @Override
    public void readTime(class_2487 compound) {
    }

    @Override
    public void writeAllData(class_2487 compound) {
        this.writeItems(compound);
        this.writeTanks(compound);
        this.writeSleepingBag(compound);
        this.writeColor(compound);
        this.writeName(compound);
    }

    @Override
    public void readAllData(class_2487 compound) {
        this.readItems(compound);
        this.readTanks(compound);
        this.readSleepingBag(compound);
        this.readColor(compound);
        this.readName(compound);
    }

    @Override
    public SingleVariantStorage<FluidVariant> getLeftTank() {
        return this.leftTank;
    }

    @Override
    public SingleVariantStorage<FluidVariant> getRightTank() {
        return this.rightTank;
    }

    @Override
    public boolean updateTankSlots() {
        return InventoryActions.transferContainerTank(this, this.getLeftTank(), 41, this.getUsingPlayer()) || InventoryActions.transferContainerTank(this, this.getRightTank(), 43, this.getUsingPlayer());
    }

    @Override
    public void markTankDirty() {
        this.method_5431();
    }

    @Override
    public boolean hasColor() {
        return this.color != 0;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean hasTileEntity() {
        return true;
    }

    @Override
    public boolean isSleepingBagDeployed() {
        return this.isSleepingBagDeployed;
    }

    public void setSleepingBagDeployed(boolean isSleepingBagDeployed) {
        this.isSleepingBagDeployed = isSleepingBagDeployed;
    }

    public boolean deploySleepingBag(class_1937 world, class_2338 pos) {
        class_2338 sleepingBagPos1;
        class_2338 sleepingBagPos2;
        class_2350 direction = this.getBlockDirection(world.method_8321(this.method_11016()));
        this.isThereSleepingBag(direction);
        if (!this.isSleepingBagDeployed && world.method_22347(sleepingBagPos2 = (sleepingBagPos1 = pos.method_10093(direction)).method_10093(direction)) && world.method_22347(sleepingBagPos1) && world.method_8320(sleepingBagPos1.method_10074()).method_30368((class_1922)world, sleepingBagPos1.method_10074(), class_2350.field_11036, class_5431.field_25822) && world.method_8320(sleepingBagPos2.method_10074()).method_30368((class_1922)world, sleepingBagPos2.method_10074(), class_2350.field_11036, class_5431.field_25822)) {
            world.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
            if (!world.field_9236) {
                world.method_8501(sleepingBagPos1, (class_2680)((class_2680)ModBlocks.SLEEPING_BAG.method_9564().method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12557));
                world.method_8501(sleepingBagPos2, (class_2680)((class_2680)ModBlocks.SLEEPING_BAG.method_9564().method_11657((class_2769)SleepingBagBlock.field_11177, (Comparable)direction)).method_11657(SleepingBagBlock.PART, (Comparable)class_2742.field_12560));
                world.method_8452(pos, ModBlocks.SLEEPING_BAG);
                world.method_8452(sleepingBagPos2, ModBlocks.SLEEPING_BAG);
            }
            this.isSleepingBagDeployed = true;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean removeSleepingBag(class_1937 world) {
        class_2350 blockFacing = this.getBlockDirection(world.method_8321(this.method_11016()));
        this.isThereSleepingBag(blockFacing);
        if (this.isSleepingBagDeployed) {
            class_2338 sleepingBagPos1 = this.field_11867.method_10093(blockFacing);
            class_2338 sleepingBagPos2 = sleepingBagPos1.method_10093(blockFacing);
            if (world.method_8320(sleepingBagPos1).method_26204() == ModBlocks.SLEEPING_BAG && world.method_8320(sleepingBagPos2).method_26204() == ModBlocks.SLEEPING_BAG) {
                world.method_8396(null, sleepingBagPos2, class_3417.field_15226, class_3419.field_15245, 0.5f, 1.0f);
                world.method_8501(sleepingBagPos2, class_2246.field_10124.method_9564());
                world.method_8501(sleepingBagPos1, class_2246.field_10124.method_9564());
                this.isSleepingBagDeployed = false;
                this.method_5431();
                return true;
            }
        } else {
            this.isSleepingBagDeployed = false;
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean isThereSleepingBag(class_2350 direction) {
        if (this.field_11863.method_8320(this.field_11867.method_10093(direction)).method_26204() == ModBlocks.SLEEPING_BAG && this.field_11863.method_8320(this.field_11867.method_10093(direction).method_10093(direction)).method_26204() == ModBlocks.SLEEPING_BAG) {
            return true;
        }
        this.isSleepingBagDeployed = false;
        return false;
    }

    public class_2350 getBlockDirection(class_2586 blockEntity) {
        if (blockEntity instanceof TravelersBackpackBlockEntity) {
            if (this.field_11863 == null || !(this.field_11863.method_8320(this.method_11016()).method_26204() instanceof TravelersBackpackBlock)) {
                return class_2350.field_11043;
            }
            return (class_2350)this.field_11863.method_8320(this.method_11016()).method_11654((class_2769)TravelersBackpackBlock.FACING);
        }
        return class_2350.field_11043;
    }

    @Override
    public InventoryImproved getInventory() {
        return this.inventory;
    }

    @Override
    public InventoryImproved getCraftingGridInventory() {
        return this.craftingInventory;
    }

    @Override
    public class_1799 decrStackSize(int index, int count) {
        class_1799 itemstack = class_1262.method_5430(this.inventory.getStacks(), (int)index, (int)count);
        if (!itemstack.method_7960()) {
            this.method_5431();
        }
        return itemstack;
    }

    @Override
    public int getLastTime() {
        return 0;
    }

    @Override
    public void setLastTime(int time) {
    }

    @Override
    public byte getScreenID() {
        return 3;
    }

    @Override
    public class_2338 getPosition() {
        return this.field_11867;
    }

    @Override
    public class_1799 getItemStack() {
        class_2248 block = this.field_11863.method_8320(this.method_11016()).method_26204();
        if (block instanceof TravelersBackpackBlock) {
            return new class_1799((class_1935)block);
        }
        return new class_1799((class_1935)ModBlocks.STANDARD_TRAVELERS_BACKPACK);
    }

    @Override
    public class_2487 getTagCompound(class_1799 stack) {
        return null;
    }

    public class_1799 transferToItemStack(class_1799 stack) {
        class_2487 compound = new class_2487();
        this.writeTanks(compound);
        this.writeItems(compound);
        this.writeTime(compound);
        if (this.hasColor()) {
            this.writeColor(compound);
        }
        stack.method_7980(compound);
        return stack;
    }

    public boolean drop(class_1936 world, class_2338 pos, class_1792 item) {
        class_1799 stack = new class_1799((class_1935)item, 1);
        this.transferToItemStack(stack);
        if (this.method_16914()) {
            stack.method_7977(this.method_5797());
        }
        class_1542 droppedItem = new class_1542((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
        return world.method_8649((class_1297)droppedItem);
    }

    @Override
    public void method_5431() {
        super.method_5431();
    }

    public class_1657 getUsingPlayer() {
        for (class_1657 player : this.field_11863.method_18467(class_1657.class, new class_238(this.method_11016()).method_1009(3.0, 3.0, 3.0))) {
            if (!(player.field_7512 instanceof TravelersBackpackBlockEntityScreenHandler)) continue;
            return player;
        }
        return null;
    }

    public boolean isUsableByPlayer(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void openGUI(class_1657 player) {
        if (!player.field_6002.field_9236) {
            player.method_17355((class_3908)new ExtendedScreenHandlerFactory(){

                public void writeScreenOpeningData(class_3222 player, class_2540 buf) {
                    buf.method_10807(TravelersBackpackBlockEntity.this.field_11867);
                }

                public class_2561 method_5476() {
                    return new class_2588(TravelersBackpackBlockEntity.this.method_11010().method_26204().method_9539());
                }

                @Nullable
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new TravelersBackpackBlockEntityScreenHandler(syncId, inv, TravelersBackpackBlockEntity.this);
                }
            });
        }
    }

    public InventoryImproved createInventory(int size) {
        return new InventoryImproved(class_2371.method_10213((int)size, (Object)class_1799.field_8037)){

            @Override
            public void method_5431() {
                TravelersBackpackBlockEntity.this.method_5431();
            }
        };
    }

    public SingleVariantStorage<FluidVariant> createFluidTank(final long capacity) {
        return new SingleVariantStorage<FluidVariant>(){

            protected FluidVariant getBlankVariant() {
                return FluidVariant.blank();
            }

            protected long getCapacity(FluidVariant variant) {
                return capacity;
            }

            protected void onFinalCommit() {
                TravelersBackpackBlockEntity.this.markTankDirty();
            }
        };
    }

    public class_2561 method_5477() {
        return this.customName != null ? this.customName : this.method_5476();
    }

    @Nullable
    public class_2561 method_5797() {
        return this.customName;
    }

    public void setCustomName(class_2561 customName) {
        this.customName = customName;
    }

    public class_2561 method_5476() {
        return new class_2588(this.method_11010().method_26204().method_9539());
    }
}

